﻿package  {
	
	import flash.display.Bitmap;
	import flash.geom.Point;
	import starling.display.*;
	import starling.events.*;
	import starling.textures.Texture;
	
	public class MyStarling extends Sprite {
		
		[Embed(source="black.png")]
		private var BlackPng:Class;
		[Embed(source="green.png")]
		private var GreenPng:Class;
		
		public function MyStarling() {
			var blackImg:SmartImage = new SmartImage(new BlackPng(), 0.1);
			var greenImg:SmartImage = new SmartImage(new GreenPng(), 0.1);
			greenImg.alphaCutoff = 64;
			blackImg.alphaCutoff = 128;
			addChild(blackImg);
			addChild(greenImg);
			blackImg.x = blackImg.y = greenImg.x = greenImg.y = 30;
			blackImg.x = 250;
			blackImg.addEventListener(TouchEvent.TOUCH, onTouch);
			greenImg.addEventListener(TouchEvent.TOUCH, onTouch);
		}
		
		
		private function onTouch(evt:TouchEvent) {
			var touchedImg:Image = evt.target as Image;
			var touch:Touch = evt.getTouch(touchedImg);
			if (touch) {
				switch (touch.phase) {
					case TouchPhase.HOVER:	touchedImg.alpha = 0.5; break;
					case TouchPhase.MOVED:
						touchedImg.x += touch.globalX - touch.previousGlobalX;
						touchedImg.y += touch.globalY - touch.previousGlobalY;
						break;
					case TouchPhase.BEGAN:	touchedImg.alpha = 0.5; break;
				}
			} else {
				touchedImg.alpha = 1;
			}
		}
		
		
		
	}
}
