﻿package {

	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.geom.*;
	import starling.display.*;
	import starling.textures.Texture;
	import starling.utils.Color;

	public class SmartImage extends Image {

		// 保持データの縮小レベル (0.01-1)
		private var scaling:Number;

		// 保持用画像データ
		private var bitmapCache:BitmapData;

		// タッチイベントを認識されるアルファーレベル (0-255)	
		public var alphaCutoff:int = 32;

		public function SmartImage(_bitmap:Bitmap, _scaling:Number=0.5) {
			scaling = Math.max(_scaling, .01);
			scaling = Math.min(scaling, 1);
			cacheData(_bitmap);
			super( Texture.fromBitmap(_bitmap) );
		}

		// テキスチャーデータを縮小して保持する
		private function cacheData(bmp:Bitmap) {
			// 保持用BitmapDataを用意する
			var w:int = Math.ceil(bmp.width * scaling);
			var h:int = Math.ceil(bmp.height * scaling);
			bitmapCache = new BitmapData(w,h,true,0);
			
			// .draw() を使って、縮小をFlashのレンダラーに任せる
			var scaleMatrix:Matrix = new Matrix();
			scaleMatrix.scale(scaling,scaling);
			bitmapCache.draw(bmp, scaleMatrix);
		}


		// タッチイベントの際のヒットテストを行う;
		public override function hitTest(localPoint:Point, forTouch:Boolean=false):DisplayObject {
			// オブジェクトが非表示、またはタッチ非対応の場合にnullを返す
			if (forTouch && (!visible || !touchable)) { return null; }

			// タッチが本オブジェクトの枠内でない場合もnullを返す
			if (! getBounds(this).containsPoint(localPoint)) { return null; }

			// 通常だったらここでthisを返すが、テキスチャーの透明度をチェックを行いましょう
			var color:uint = bitmapCache.getPixel32(localPoint.x*scaling, localPoint.y*scaling);
			if (Color.getAlpha(color) > alphaCutoff) {
				return this;// ヒットがありました
			} else {
				return null;
			}
		}
	}
}